/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.widgets;

import com.quantumdata.widgets.IStdDialogContext;
import com.quantumdata.widgets.IStdDlgPanel;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDTitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StdDialog
extends JDialog
implements IStdDialogContext,
ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int X_INNER_OFFSET = 60;
    private static final int Y_INNER_OFFSET = 90;
    private static JFrame g_defaultParent = null;
    private static boolean g_canResize = true;
    private boolean m_isOk = false;
    private IStdDlgPanel m_dlgPanel;
    private JButton m_okAction;
    private JButton m_cancelAction;
    private JPanel m_btPanel;

    public StdDialog(String string, IStdDlgPanel iStdDlgPanel) {
        super(g_defaultParent, string, true);
        this.m_dlgPanel = iStdDlgPanel;
        this.setDefaultCloseOperation(2);
        this.setBackground(QDStdUI.getBackground());
        this.setResizable(g_canResize);
        this.setUndecorated(!g_canResize);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.m_dlgPanel.getPanel(), "Center");
        jPanel.setBackground(QDStdUI.getBackground());
        this.add(jPanel);
        Border border = BorderFactory.createLineBorder(QDStdUI.getBorderColor(), 1);
        Border border2 = QDStdUI.getRaisedBorder();
        jPanel.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.m_btPanel = new JPanel();
        this.m_btPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.m_btPanel.setBackground(QDStdUI.getBackground());
        this.m_okAction = new QDButton("OK");
        this.m_okAction.setActionCommand("OK");
        this.m_okAction.addActionListener(this);
        this.m_btPanel.add(this.m_okAction);
        this.m_cancelAction = new QDButton("Cancel");
        this.m_cancelAction.setActionCommand("cancel");
        this.m_cancelAction.addActionListener(this);
        this.m_btPanel.add(this.m_cancelAction);
        jPanel.add((Component)this.m_btPanel, "South");
        QDTitlePanel qDTitlePanel = new QDTitlePanel();
        qDTitlePanel.setTitle(string);
        jPanel.add((Component)qDTitlePanel, "North");
    }

    public static void setDefaultParent(JFrame jFrame) {
        g_defaultParent = jFrame;
    }

    public static void setCanResize(boolean bl) {
        g_canResize = bl;
    }

    public void startDialog() {
        this.pack();
        Point point = this.getParent().getLocationOnScreen();
        Dimension dimension = this.getParent().getSize();
        Dimension dimension2 = this.getSize();
        this.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
        this.m_dlgPanel.startingDlg(this);
        this.setVisible(true);
    }

    public boolean wasOkSelected() {
        return this.m_isOk;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.stop(string);
    }

    public void enableCloseOption() {
        this.m_okAction.setVisible(false);
        this.m_cancelAction.setVisible(true);
        this.m_cancelAction.setText("Close");
        this.adjustCmdPanel();
    }

    public void stop(String string) {
        this.m_isOk = false;
        if (string.compareToIgnoreCase("ok") == 0) {
            this.m_isOk = true;
        }
        this.m_dlgPanel.stoppingDlg(this);
        this.setVisible(false);
    }

    public void enableOK(boolean bl) {
        this.m_okAction.setVisible(bl);
        this.adjustCmdPanel();
    }

    public void enableCANCEL(boolean bl) {
        if (bl) {
            this.m_cancelAction.setText("Cancel");
        }
        this.m_cancelAction.setVisible(bl);
        this.adjustCmdPanel();
    }

    private void adjustCmdPanel() {
        this.m_btPanel.setVisible(this.m_okAction.isVisible() || this.m_cancelAction.isVisible());
    }

    public void fitWithin(Component component) {
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        this.setSize(dimension.width - 120, dimension.height - 180);
        this.setLocation(point.x + 60, point.y + 90);
    }

    public void repack() {
        this.pack();
    }
}

